<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
/**
 * @package Email-Users-Custom-List
 * @version 1.6
 */
/*
Plugin Name: Email Users Custom List
Plugin URI: http://michaelwalsh.org/wordpress/wordpress-plugins/email-users-custom-list/
Description: This plugin shows how a custom meta filter can be used in conjunction with the Email Users plugin to address a Custom List of Users.
Author: Mike Walsh
Version: 1.6
Author URI: http://michaelwalsh.org/
*/

add_action( 'mailusers_user_custom_meta_filter', 'first_names_starting_with_anything_but_d', 5 );

function first_names_starting_with_anything_but_d()
{
    mailusers_register_user_custom_meta_filter('First Name: Not D', 'first_name', '^D', 'NOT REGEXP');
}

add_action( 'mailusers_user_custom_meta_filter', 'last_names_starting_with_m', 5 );

function last_names_starting_with_m()
{
    mailusers_register_user_custom_meta_filter('Last Name: M', 'last_name', '^M', 'REGEXP');
}

add_action( 'mailusers_user_custom_meta_filter', 'last_names_starting_with_s_through_z', 5 );

function last_names_starting_with_s_through_z()
{
    mailusers_register_user_custom_meta_filter('Last Name: S-Z', 'last_name', '^[S-Z]', 'REGEXP');
}

add_action( 'mailusers_user_custom_meta_filter', 'first_name_alex', 5 );

function first_name_alex()
{
    mailusers_register_user_custom_meta_filter('First Name: Alex', 'first_name', 'Alex');
}

//add_action( 'mailusers_user_custom_meta_filter', 'mail_wendy_matt', 5 );

function mail_wendy_matt()
{
    mailusers_register_user_custom_meta_filter('Last Name: Matt', 'last_name', 'Matt');
}

//add_action( 'mailusers_group_custom_meta_filter', 'send_to_fire_department', 5 );

function send_to_fire_department()
{
    mailusers_register_group_custom_meta_filter('Fire Department', 'department', 'fire');
}


//add_action( 'mailusers_group_custom_meta_filter', 'send_to_police_department', 5 );

function send_to_police_department()
{
    mailusers_register_group_custom_meta_filter('Police Department', 'department', 'police');
}


add_action( 'mailusers_group_custom_meta_key_filter', 'send_to_departments', 5 );

function send_to_departments()
{
    mailusers_register_group_custom_meta_key_filter('department', null, 'send_to_departments_label');
}

function send_to_departments_label($mk, $mv)
{
    return(ucwords($mk) . ' = ' . ucwords($mv)) ;
}

add_action( 'mailusers_group_custom_meta_filter', 'send_to_public_works', 5 );

function send_to_public_works()
{
    mailusers_register_group_custom_meta_filter('Public Works', 'publicworks', true);
}

//add_action( 'mailusers_update_custom_meta_filters', 'update_publicworks_meta_filter', 5 );

function update_publicworks_meta_filter()
{
    $pw_mk = 'publicworks' ;
    $dept_mk = 'department' ;

    //  Define the valid matches - the array keys match user
    //  meta keys and the array values match the user meta values.
    //
    //  The array could contain a mixed set of meta keys and values
    //  in order to group users based on an arbitrary collection of
    //  user meta data.

    $publicworks = array(
        array($dept_mk => 'fire'),
        array($dept_mk => 'police'),
        array($dept_mk => 'water and sewer'),
        array($dept_mk => 'parks and recreation'),
    ) ;

    //  Remove all instances of the Public Works meta key
    //  to account for employees no longer with Public Works
	$uq = new WP_User_Query(array('meta_key' => $pw_mk)) ;

    foreach ($uq->get_results() as $u)
        delete_user_meta($u->ID, $pw_mk) ;

    //  Loop through the departs and select Users accordingly
    foreach  ($publicworks as $pw)
    {
    	$uq = new WP_User_Query(array('meta_key' => $dept_mk, 'meta_value' => $pw[$dept_mk])) ;

        //  Loop through the users in the department and tag them as Public Works employees
        foreach ($uq->get_results() as $u)
            update_user_meta($u->ID, $pw_mk, true) ;
    }
}
?>
