<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
/**
 *
 * header.php template file
 *
 * (c) 2009 by Mike Walsh
 *
 * @author Mike Walsh <mike_walsh@mindspring.com>
 * @package sandbox-lego
 * @subpackage Sandbox
 * @version $Revision$
 * @lastmodified $Author$
 * @lastmodifiedby $Date$
 *
 */
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes() ?>>
<head profile="http://gmpg.org/xfn/11">
	<title><?php wp_title( '-', true, 'right' ); echo wp_specialchars( get_bloginfo('name'), 1 ) ?></title>
	<meta http-equiv="content-type" content="<?php bloginfo('html_type') ?>; charset=<?php bloginfo('charset') ?>" />
    <link rel="shortcut icon" href="<?php echo dirname(get_bloginfo('stylesheet_url')) . '/images/soccer/favicon.ico' ; ?>" />
	<link rel="stylesheet" type="text/css" href="<?php bloginfo('stylesheet_url') ?>" />
<?php global $ec3; $ec3->nocss=true; ?>
<?php wp_head() // For plugins ?>
	<link rel="alternate" type="application/rss+xml" href="<?php bloginfo('rss2_url') ?>" title="<?php printf( __( '%s latest posts', 'sandbox' ), wp_specialchars( get_bloginfo('name'), 1 ) ) ?>" />
	<link rel="alternate" type="application/rss+xml" href="<?php bloginfo('comments_rss2_url') ?>" title="<?php printf( __( '%s latest comments', 'sandbox' ), wp_specialchars( get_bloginfo('name'), 1 ) ) ?>" />
	<link rel="pingback" href="<?php bloginfo('pingback_url') ?>" />
</head>

<body class="<?php sandbox_body_class() ?>">

<?php
$theme_options = casl_theme_get_options() ;
//var_dump($theme_options) ;
$theme_header_style = "" ;
?>

<div id="wrapper" class="hfeed">

	<div align="center" id="header">

<!--  Handle the league logo image -->

<div id="caslleaguelogoimg" style="<?php echo $theme_options[CASL_THEME_OPTION_LEAGUE_LOGO_CSS]; ?>">
<?php

if (!empty($theme_options[CASL_THEME_OPTION_LEAGUE_LOGO]))
{
    $leaguelogoimg = sprintf("%s/images/CASL/%s",
        dirname(get_bloginfo('stylesheet_url')),
        sprintf(CASL_THEME_LEAGUE_LOGO_IMAGE,
        $theme_options[CASL_THEME_OPTION_LEAGUE_LOGO])) ;
    
?>
<a href="<?php bloginfo('url'); ?>"><img src="<?php print $leaguelogoimg ; ?>" alt="<?php $alt = bloginfo('name') . ' Home' ; print $alt ;?>"></a>
<?php
}
?>
    
</div>

<!--  Handle the left header image -->

<div id="casllfthdrimg" style="<?php echo $theme_options[CASL_THEME_OPTION_HIL_CSS]; ?>">
<?php

if (!empty($theme_options[CASL_THEME_OPTION_HIL]))
{
    $lfthdrimg = wp_get_attachment_image_src($theme_options[CASL_THEME_OPTION_HIL], 'full') ;
    
?>
<a href="<?php bloginfo('url'); ?>"><img src="<?php print $lfthdrimg[0] ; ?>" alt="<?php $alt = bloginfo('name') . ' Home' ; print $alt ;?>"></a>
<?php
}
?>
    
</div>

<!--  Handle the right header image -->

<div id="caslrghthdrimg" style="<?php echo $theme_options[CASL_THEME_OPTION_HIR_CSS]; ?>">
<?php

if (!empty($theme_options[CASL_THEME_OPTION_HIR]))
{
    $rghthdrimg = wp_get_attachment_image_src($theme_options[CASL_THEME_OPTION_HIR], 'full') ;
    
?>
<a href="<?php bloginfo('url'); ?>"><img src="<?php print $rghthdrimg[0] ; ?>" alt="<?php $alt = bloginfo('name') . ' Home' ; print $alt ;?>"></a>
<?php
}
?>
    
</div>

<!--  Handle the center header image -->

<div id="caslctrhdrimg" style="<?php echo $theme_options[CASL_THEME_OPTION_HIC_CSS]; ?>">
<?php

if (!empty($theme_options[CASL_THEME_OPTION_HIC]))
{
    $ctrhdrimg = wp_get_attachment_image_src($theme_options[CASL_THEME_OPTION_HIC], 'full') ;
    
?>
<a href="<?php bloginfo('url'); ?>"><img src="<?php print $ctrhdrimg[0] ; ?>" alt="<?php $alt = bloginfo('name') . ' Home' ; print $alt ;?>"></a>
<?php
}
?>
    
</div>


	<div id="header-info">
<div id="headerimage"></div>
		<h1 style="<?php echo $theme_options[CASL_THEME_OPTION_BLOG_TITLE_CSS]; ?>" id="blog-title"><span><a href="<?php bloginfo('home') ?>/" title="<?php echo wp_specialchars( get_bloginfo('name'), 1 ) ?>" rel="home"><?php bloginfo('name') ?></a></span></h1>
		<div style="<?php echo $theme_options[CASL_THEME_OPTION_BLOG_TAGLINE_CSS]; ?>" id="blog-description"><?php bloginfo('description') ?></div>
	</div><!--  #header-info -->

	</div><!--  #header -->

	<div id="access">
		<div class="skip-link"><a href="#content" title="<?php _e( 'Skip to content', 'sandbox' ) ?>"><?php _e( 'Skip to content', 'sandbox' ) ?></a></div>

		<ul class="sf-menu"> 
			<li class="page_item"><a href="<?php bloginfo('home') ?>/" title="<?php echo wp_specialchars( get_bloginfo('name'), 1 ) ?>" rel="home"><?php _e('Home') ?></a></li>
			<?php wp_list_pages('sort_column=menu_order&title_li='); ?> 
		</ul>
	</div><!-- #access -->

	<div id="headersidebar" class="sidebar">
		<ul class="xoxo">
<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('Header Sidebar') ) : // begin header sidebar widgets ?>
<?php endif; // end header sidebar widgets  ?>
		</ul>
    </div>

