#!/bin/sh
## vim: set expandtab tabstop=4 shiftwidth=4:
##
##
## (c) 2009 by Mike Walsh
##
## @author Mike Walsh <mike_walsh@mindspring.com>
## @package casl-soccer
## @version $Revision$
## @lastmodified $Author$
## @lastmodifiedby $Date$
##
##
## Shell script to generate CSS color derivitives.  SuperFish
## menus are derived from the SuperFish source using a simple
## sed substitution of one color to another.  The theme CSS 
## files are generated similarly, starting from a baseline CSS
## file and replacing the placeholders with color values.
##
##

##  Define SuperFish menus CSS files

SUPERFISH="../js/superfish-1.4.8"
SUPERFISHCSS="${SUPERFISH}/css/superfish.css"
SUPERFISHNAVBARCSS="${SUPERFISH}/css/superfish-navbar.css"

##  Define theme CSS files

CASLSOCCERTHEMEBASELINECSS="casl-soccer-baseline.css"
CASLSOCCERTHEMECSS="casl-soccer.css"
CASLSOCCERTHEMELOGINBASELINECSS="casl-soccer-login-baseline.css"
CASLSOCCERTHEMELOGINCSS="casl-soccer-login.css"

##  Superfish source Menu colors
##  #13a    - menu font color
##  #BDD2FF - menu color
##  #CFDEFF - hover color
##  #AABDE6 - sub-menu color
##  #D1DFFF - ? color
##  #E6EEFF - ? color
##  #9AAEDB - sub-sub-menu color
##  #fff    - border left color

##  Generate the "red" derivitive

sed -e 's/#13a/#FFFFFF/g' \
    -e 's/#BDD2FF/#000000/g' \
    -e 's/#CFDEFF/#808080/g' \
    -e 's/#AABDE6/#717171/g' \
    -e 's/#D1DFFF/#00FFFF/g' \
    -e 's/#E6EEFF/#FF00FF/g' \
    -e 's/#9AAEDB/#818181/g' \
    -e 's/#fff/#808080/g' \
    ${SUPERFISHCSS} > `basename ${SUPERFISHCSS} .css`.css

##  Generate the "CASL" CSS files

sed -e 's/CASL_BG_COLOR/#FFFFFF/g' \
    -e 's/CASL_FG_COLOR/#000000/g' \
    -e 's/CASL_MENU_BAR_COLOR/#000000/g' \
    -e 's/CASL_DEFAULT_LINK_COLOR/#AA1E03/g' \
    -e 's/CASL_DEFAULT_HEADING_COLOR/#848484/g' \
    -e 's/CASL_HEADER_HEADING_COLOR/#FFFFFF/g' \
    -e 's/CASL_LINK_COLOR/#C01C08/g' \
    -e 's/CASL_DIV_BG_COLOR/#FFFFFF/g' \
    -e 's/CASL_DIV_BORDER_COLOR/#8A8A8A/g' \
    -e 's/CASL_DIV_WRAPPER_COLOR/#000000/g' \
    -e 's/CASL_DIV_HEADER_COLOR/#000000/g' \
    -e 's/CASL_DIV_FOOTER_COLOR/#8A8A8A/g' \
    -e 's/CASL_DIV_FOOTER_BG_COLOR/#000000/g' \
    -e 's/CASL_SIDEBAR_UL_BG_COLOR/#DDDDDD/g' \
    -e 's/CASL_SIDEBAR_UL_FG_COLOR/#F66802/g' \
    -e 's/CASL_SIDEBAR_UL_BORDER_COLOR/#8A8A8A/g' \
    -e 's/CASL_SIDEBAR_UL_DECOR_COLOR/#C01C08/g' \
    -e 's/CASL_EC3_BG_COLOR/#EFEFEF/g' \
    -e 's/CASL_EC3_FG_COLOR/#C01C08/g' \
    -e 's/CASL_SIDEBAR_DIV_BG_COLOR/#DDDDDD/g' \
    -e 's/CASL_SIDEBAR_DIV_FG_COLOR/#CDCDCD/g' \
    -e 's/CASL_ENTRY_TITLE_BG_COLOR/#DDDDDD/g' \
    -e 's/CASL_ENTRY_TITLE_FG_COLOR/#CDCDCD/g' \
    -e 's/CASL_ENTRY_TITLE_BORDER_COLOR/#656565/g' \
    -e 's/CASL_CALENDAR_BODY_COLOR/#EFEFEF/g' \
    -e 's/CASL_CALENDAR_HEAD_COLOR/#DDDDDD/g' \
    -e 's/CASL_ENTRY_META_BG_COLOR/#EFEFEF/g' \
    -e 's/CASL_ENTRY_META_FG_COLOR/#333333/g' \
    -e 's/CASL_ENTRY_META_BORDER_COLOR/#656565/g' \
    -e 's/CASL_SIDEBAR_LINK_BG_COLOR/#EFEFEF/g' \
    -e 's/CASL_SIDEBAR_LINK_FG_COLOR/#EFEFEF/g' \
    -e 's/CASL_SIDEBAR_DIV_BORDER_COLOR/#656565/g' \
    -e 's/CASL_LOGIN_HEADER_BG_COLOR/#656565/g' \
    -e 's/CASL_COMMENTS_DECOR_COLOR/#C01C08/g' \
    -e 's/CASL_CODE_FONT_COLOR/#C01C08/g' \
    -e 's/CASL_SUPERFISH_IE_FIX/#808080/g' \
    ${CASLSOCCERTHEMEBASELINECSS} > ${CASLSOCCERTHEMECSS}

sed -e 's/CASL_FG_COLOR/#FFFFFF/g' \
    -e 's/CASL_DEFAULT_LINK_COLOR/#AA1E03/g' \
    -e 's/CASL_LOGIN_HEADER_BG_COLOR/#656565/g' \
    -e 's/CASL_LOGIN_BUTTON_COLOR/#8A8A8A/g' \
    -e 's/CASL_LOGIN_BUTTON_BORDER_COLOR/#DDDDDD/g' \
    -e 's/CASL_LOGIN_BUTTON_HOVER_BORDER_COLOR/#656565/g' \
    ${CASLSOCCERTHEMELOGINBASELINECSS} > ${CASLSOCCERTHEMELOGINCSS}
